/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.Library;
import org.lwjgl.system.SharedLibraryLoader;

public final class LibraryResource {
    private LibraryResource() {
    }

    public static Path load(String name) {
        return LibraryResource.load(LibraryResource.class, name);
    }

    public static Path load(Class<?> context, String name) {
        return LibraryResource.load(context, name, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Path load(Class<?> context, String name, boolean printError) {
        String paths;
        Path path;
        block24: {
            APIUtil.apiLog("Loading library resource: " + name);
            path = Paths.get(name, new String[0]);
            if (path.isAbsolute()) {
                if (!Files.exists(path, new LinkOption[0])) {
                    if (!printError) throw new IllegalStateException("Failed to locate library resource: " + name);
                    LibraryResource.printError();
                    throw new IllegalStateException("Failed to locate library resource: " + name);
                }
                APIUtil.apiLog("\tSuccess");
                return path;
            }
            URL libURL = context.getClassLoader().getResource(name);
            if (libURL == null) {
                path = LibraryResource.loadFromLibraryPath(name);
                if (path != null) {
                    return path;
                }
            } else {
                boolean debugLoader = Configuration.DEBUG_LOADER.get(false);
                try {
                    if (debugLoader) {
                        APIUtil.apiLog("\tUsing SharedLibraryLoader...");
                    }
                    try (FileChannel ignored = SharedLibraryLoader.load(name, name, libURL);){
                        path = LibraryResource.loadFromLibraryPath(name);
                        if (path != null) {
                            Path path2 = path;
                            return path2;
                        }
                    }
                }
                catch (Exception e) {
                    if (!debugLoader) break block24;
                    e.printStackTrace(APIUtil.DEBUG_STREAM);
                }
            }
        }
        if ((paths = System.getProperty("java.library.path")) != null && (path = LibraryResource.load(name, "java.library.path", paths)) != null) {
            return path;
        }
        if (!printError) throw new IllegalStateException("Failed to locate library resource: " + name);
        LibraryResource.printError();
        throw new IllegalStateException("Failed to locate library resource: " + name);
    }

    @Nullable
    private static Path loadFromLibraryPath(String libName) {
        String paths = Configuration.LIBRARY_PATH.get();
        if (paths == null) {
            return null;
        }
        return LibraryResource.load(libName, Configuration.LIBRARY_PATH.getProperty(), paths);
    }

    @Nullable
    private static Path load(String name, String property, String paths) {
        Path resource = Library.findFile(paths, name);
        if (resource == null) {
            APIUtil.apiLog(String.format("\t%s not found in %s=%s", name, property, paths));
            return null;
        }
        APIUtil.apiLog(String.format("\tLoaded from %s: %s", property, resource));
        return resource;
    }

    public static Path load(Class<?> context, Configuration<String> name, String ... defaultNames) {
        return LibraryResource.load(context, name, null, defaultNames);
    }

    public static Path load(Class<?> context, Configuration<String> name, @Nullable Supplier<Path> fallback, String ... defaultNames) {
        if (defaultNames.length == 0) {
            throw new IllegalArgumentException("No default names specified.");
        }
        String resourceName = name.get();
        if (resourceName != null) {
            return LibraryResource.load(context, resourceName);
        }
        if (fallback == null && defaultNames.length <= 1) {
            return LibraryResource.load(context, defaultNames[0]);
        }
        try {
            return LibraryResource.load(context, defaultNames[0], false);
        }
        catch (Throwable t) {
            for (int i = 1; i < defaultNames.length; ++i) {
                try {
                    return LibraryResource.load(context, defaultNames[i], fallback == null && i == defaultNames.length - 1);
                }
                catch (Throwable throwable) {
                    continue;
                }
            }
            if (fallback != null) {
                return fallback.get();
            }
            throw t;
        }
    }

    private static void printError() {
        Library.printError("[LWJGL] Failed to load a library resource. Possible solutions:\n\ta) Add the directory that contains the resource to -Djava.library.path or -Dorg.lwjgl.librarypath.\n\tb) Add the JAR that contains the resource to the classpath.");
    }

    static {
        Library.initialize();
    }
}

