/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;

public abstract class Platform
extends Enum<Platform> {
    public static final /* enum */ Platform LINUX;
    public static final /* enum */ Platform MACOSX;
    public static final /* enum */ Platform WINDOWS;
    private static final Platform current;
    private static final Architecture architecture;
    private static final Function<String, String> bundledLibraryNameMapper;
    private static final Function<String, String> bundledLibraryPathMapper;
    private final String name;
    private static final /* synthetic */ Platform[] $VALUES;

    public static Platform[] values() {
        return (Platform[])$VALUES.clone();
    }

    public static Platform valueOf(String name) {
        return Enum.valueOf(Platform.class, name);
    }

    private Platform(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    abstract String mapLibraryName(String var1);

    public static Platform get() {
        return current;
    }

    public static Architecture getArchitecture() {
        return architecture;
    }

    public static String mapLibraryNameBundled(String name) {
        return bundledLibraryNameMapper.apply(name);
    }

    static String mapLibraryPathBundled(String name) {
        return bundledLibraryPathMapper.apply(name);
    }

    private static Function<String, String> getMapper(@Nullable Object mapper, Function<String, String> defaultMapper, Function<String, String> legacyMapper) {
        if (mapper == null || "default".equals(mapper)) {
            return defaultMapper;
        }
        if ("legacy".equals(mapper)) {
            return legacyMapper;
        }
        if (mapper instanceof Function) {
            return (Function)mapper;
        }
        String className = mapper.toString();
        try {
            return (Function)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable t) {
            if (Checks.DEBUG) {
                t.printStackTrace(APIUtil.DEBUG_STREAM);
            }
            APIUtil.apiLog(String.format("Warning: Failed to instantiate bundled library mapper: %s. Using the default.", className));
            return defaultMapper;
        }
    }

    static {
        boolean is64Bit;
        LINUX = new Platform("Linux"){
            private final Pattern SO = Pattern.compile("(?:^|/)lib\\w+[.]so(?:[.]\\d+)*$");

            @Override
            String mapLibraryName(String name) {
                if (this.SO.matcher(name).find()) {
                    return name;
                }
                return System.mapLibraryName(name);
            }
        };
        MACOSX = new Platform("macOS"){
            private final Pattern DYLIB = Pattern.compile("(?:^|/)lib\\w+(?:[.]\\d+)*[.]dylib$");

            @Override
            String mapLibraryName(String name) {
                if (this.DYLIB.matcher(name).find()) {
                    return name;
                }
                return System.mapLibraryName(name);
            }
        };
        WINDOWS = new Platform("Windows"){

            @Override
            String mapLibraryName(String name) {
                if (name.endsWith(".dll")) {
                    return name;
                }
                return System.mapLibraryName(name);
            }
        };
        $VALUES = new Platform[]{LINUX, MACOSX, WINDOWS};
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            current = WINDOWS;
        } else if (osName.startsWith("Linux") || osName.startsWith("FreeBSD") || osName.startsWith("SunOS") || osName.startsWith("Unix")) {
            current = LINUX;
        } else if (osName.startsWith("Mac OS X") || osName.startsWith("Darwin")) {
            current = MACOSX;
        } else {
            throw new LinkageError("Unknown platform: " + osName);
        }
        String osArch = System.getProperty("os.arch");
        boolean bl = is64Bit = osArch.contains("64") || osArch.startsWith("armv8");
        architecture = osArch.startsWith("arm") || osArch.startsWith("aarch64") ? (is64Bit ? Architecture.ARM64 : Architecture.ARM32) : (is64Bit ? Architecture.X64 : Architecture.X86);
        bundledLibraryNameMapper = Platform.getMapper(Configuration.BUNDLED_LIBRARY_NAME_MAPPER.get(), name -> name, name -> is64Bit ? name : name + "32");
        bundledLibraryPathMapper = Platform.getMapper(Configuration.BUNDLED_LIBRARY_PATH_MAPPER.get(), name -> architecture.name().toLowerCase() + "/" + name, name -> name);
    }

    public static enum Architecture {
        X64,
        X86,
        ARM64,
        ARM32;

    }
}

